**************************************************************************************************
*******************DATA FOR "THE REAL EFFECTS OF DEBT COVENANTS" PAPER - SET UP*******************
*************************DATE: AUG 2022 **********************************************************
************************ AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load Morningstar data
* Morningstar data are not available to the public
use "\\Data\morningstar.dta", clear
* clean matching id
replace asxcode = lower(asxcode)
destring acn, replace ignore(" " "NA" "ARBN" "ARSN")
* drop financial sector
drop if gics_sector==40

//Merge with Debt Covenants data
merge m:1 asxcode year using "\\Data\covenants_data.dta"
* keep only those we have report for
keep if _merge==3 | _merge==2
drop _merge

* keep only 2002 onwards
keep if year>=2002

//Set panel
drop id
egen id = group(asxcode)
xtset id year, delta(1)

//Age in sample
bysort id: g yearcount = _n
bysort id: egen age = max(yearcount)

//Interest coverage ratio
g intpayments = intexp
replace intpayments = borrowcosts if  intexp==.
replace intpayments = . if intpayments < 0
g icr = ebitda/intpayments

//Interest rates
g ir = intpayments/debt if debt>0
replace ir = . if intpayments==0

//Debt-to-EBITDA ratio
g dte = debt/ebitda

//Construct relevant control variables
g logrevenue = log(revenue)
g logassets = log(assets)
g logcash = log(cash)
g logdebt = log(debt)
g Lrevenue = L.logrevenue
g Lassets = L.logassets
g Lcash = L.logcash
g Lgearing = L.gearingratiopreferred
g Licr = L.icr
g Ldte = L.dte
g Ldebt = L.logdebt
g Lroe = L.roepreferred

g Drevenue = D.logrevenue
g Dassets = D.logassets
g Dcash = D.logcash
g Dgearing = D.gearingratiopreferred
g Dicr = D.icr
g Ddte = D.dte

//Drop some negative obs
g leverageratio = debt/assets
g cashratio = currentliquiditypreferred/assets
g quickratio = curasset/curliab 

drop if assets < 0
drop if liabilities < 0
drop if curasset < 0
drop if curliab < 0
drop if cashratio > 1 & cashratio ~=.
drop if cashratio < 0
drop if quickratio > 100 & quickratio ~=.
drop if assets < 0
drop if liabilities < 0
drop if curasset < 0
drop if curliab < 0

//SME
g sme = 0
replace sme=1 if revenue < 10 & year>=2015
replace sme=1 if revenue < 2 & year<2015
g Lsme = L.sme

//Investment and staff expenses
g loginvestment = log(investment)
g staffexpenses = -staffandemployeeexpenses2200
g logstaffexpenses = log(staffexpenses)
g Linvestment = L.investment
g Lstaffexpenses = L.staffexpenses
g Dinvestment = D.loginvestment
g Dstaffexpenses = D.logstaffexpenses

//Debt covenants configurations
g covtype_c = .
*With ICC
replace covtype_c = 1 if icc == 1
*No ICC but with other types of cov
replace covtype_c = 2 if (icc == 0 & (oec == 1 | abc == 1))
*No cov
replace covtype_c = 0 if (cov==0)
*Remove those who didn't report the type
replace covtype_c = . if (icc == 0 & oec == 0 & abc == 0 & cov == 1)
*Lagged
g Lcovtype_c = L.covtype_c

//Covenants and violations
g Lcov = L.cov
g Lbreach = L.breach
* Ex-ante disciplinary treatment group
g disg = .
replace disg = 0 if Lcov == 0 & cov == 0
replace disg = 1 if Lcov == 0 & cov == 1 & breach == 0
g Ldisg = L.disg
* Ex-post punishing treatment group
g pung = .
replace pung = 0 if Lcov == 1 & cov == 1 & Lbreach == 0 & breach == 0
replace pung = 1 if Lcov == 1 & cov == 1 & Lbreach == 0 & breach == 1
g Lpung = L.pung

//Merge with annual monetary policy shocks (Beckers 2020) data
merge m:1 year using "\\Data\BTCS_yearly.dta", nogen keep(match master)

//Unsecured loans

foreach x in bankloansunsecured315 bankloansunsecured359 bankfacilitiesunsecured2234 bankfacilitiesunsecured2235 billsnotesbondscommercialpaperse notesbondscommercialpapersecured{
replace `x' = 0 if `x'==.
}
foreach x in bankloanssecured314 bankloanssecured358 bankfacilitiessecured2232 bankfacilitiessecured2233 billsnotesbondscommercialpaperun notesbondscommercialpaperunsecur{
replace `x' = 0 if `x'==.
}

g unsecuredloans = bankloansunsecured315 + bankloansunsecured359 + bankfacilitiesunsecured2234 + bankfacilitiesunsecured2235 + billsnotesbondscommercialpaperun + notesbondscommercialpaperunsecur
bysort year: sum unsecuredloans

g securedloans = bankloanssecured314 + bankloanssecured358 + bankfacilitiessecured2232 + bankfacilitiessecured2233 + billsnotesbondscommercialpaperse + notesbondscommercialpapersecured
bysort year: sum securedloans

g haveunsec = ( unsecuredloans > 0)
g havesec = ( securedloans > 0)

g haveunsectosec = haveunsec/(havesec+havesec)
g postgfc = (year>2010)
tabstat haveunsectosec if abc==1, stats(mean) by(postgfc)
tabstat haveunsectosec if icc==1 | oec==1, stats(mean) by(postgfc)
tabstat haveunsectosec if icc==1 | oec==1 | abc==1, stats(mean) by(postgfc)

//Changed from ICC to NICC: less than 5 per cent changed from ICC to NICC and doesn't follow a particular trend over time
g changetype_c = 0 if Lcovtype_c == 1 & covtype_c == 1
replace changetype_c = 1 if Lcovtype_c == 1 & covtype_c == 2
bysort year: sum changetype_c

//Save data for analysis
save "\\Output\covenants_analysis.dta", replace
